--TEST--
swoole_client_sync: long connection[4]
--SKIPIF--
<?php require __DIR__ . '/../include/skipif.inc'; ?>
--FILE--
<?php
require __DIR__ . '/../include/bootstrap.php';

$pm = new ProcessManager;

$pm->parentFunc = function () use ($pm) {

    $client1 = new Swoole\Client(SWOOLE_SOCK_TCP | SWOOLE_KEEP | SWOOLE_SYNC, SWOOLE_SOCK_SYNC, "id");
    $r = @$client1->connect(TCP_SERVER_HOST, $pm->getFreePort(), 0.5);
    Assert::true($r);

    $client2 = new Swoole\Client(SWOOLE_SOCK_TCP | SWOOLE_KEEP | SWOOLE_SYNC, SWOOLE_SOCK_SYNC, "id");
    $r = @$client2->connect(TCP_SERVER_HOST, $pm->getFreePort(), 0.5);
    Assert::true($r);

    Assert::assert($client1->sock != $client2->sock);

    @$client1->close(true);

    $client2->send("hello");
    echo $client2->recv();
    @$client2->close(true);
    $pm->kill();
};

$pm->childFunc = function () use ($pm) {
    $server = new Swoole\Server('127.0.0.1', $pm->getFreePort(), SWOOLE_BASE);
    $server->set(['worker_num' => 1, 'log_file' => '/dev/null']);
    $server->on('workerStart', function () use ($pm) {
        $pm->wakeup();
    });
    $server->on('receive', function (Swoole\Server $serv, $fd, $tid, $data) {
        $serv->send($fd, "Swoole $data\n");
    });
    $server->start();
};

$pm->childFirst();
$pm->run();

?>
--EXPECT--
Swoole hello
