/*
            Copyright Oliver Kowalke 2009.
            Copyright Thomas Sailer 2013.
   Distributed under the Boost Software License, Version 1.0.
      (See accompanying file LICENSE_1_0.txt or copy at
            http://www.boost.org/LICENSE_1_0.txt)
*/

/****************************************************************************************
 *                                                                                      *
 *  ----------------------------------------------------------------------------------
 *  |    0    |    1    |                                                            |
 *  ----------------------------------------------------------------------------------
 *  |   0x0   |   0x4   |                                                            |
 *  ----------------------------------------------------------------------------------
 *  |    <indicator>    |                                                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    2    |    3    |    4     |    5    |    6    |    7    |    8    |    9    |
 *  ----------------------------------------------------------------------------------
 *  |   0x8   |   0xc   |   0x10   |   0x14  |   0x18  |   0x1c  |   0x20  |   0x24  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |   10    |   11    |    12    |    13   |    14   |    15   |    16   |    17   |
 *  ----------------------------------------------------------------------------------
 *  |   0x28  |  0x2c   |   0x30   |   0x34  |   0x38  |   0x3c  |   0x40  |   0x44  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    18   |    19   |    20   |    21    |    22   |    23   |    24   |    25   |
 *  ----------------------------------------------------------------------------------
 *  |   0x48  |   0x4c  |   0x50  |   0x54   |   0x58  |   0x5c  |  0x60   |   0x64  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    26   |    27   |    28    |   29    |    30   |    31   |    32   |    33   |
 *  ----------------------------------------------------------------------------------
 *  |   0x68  |   0x6c  |   0x70   |   0x74  |   0x78  |   0x7c  |   0x80  |   0x84  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    34    |   35   |    36    |    37   |    38   |    39   |    40   |    41   |
 *  ----------------------------------------------------------------------------------
 *  |   0x88   |  0x8c  |   0x90   |   0x94  |   0x98  |   0x9c  |   0xa0  |   0xa4  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    42   |    43   |    44    |    45   |    46   |    47   |    48   |    49   |
 *  ----------------------------------------------------------------------------------
 *  |   0xa8  |   0xac  |   0xb0   |   0xb4  |   0xb8  |   0xbc  |   0xc0  |   0xc4  |
 *  ----------------------------------------------------------------------------------
 *  | fc_mxcsr|fc_x87_cw|     <alignment>    |      fbr_strg     |      fc_dealloc   |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    50   |   51    |    52    |    53   |    54   |    55   |    56   |    57   |
 *  ----------------------------------------------------------------------------------
 *  |   0xc8  |  0xcc   |   0xd0   |   0xd4  |   0xd8  |   0xdc  |   0xe0  |   0xe4  |
 *  ----------------------------------------------------------------------------------
 *  |      limit        |       base         |      R12          |        R13        |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    58   |    59   |    60   |    61    |    62   |    63   |    64   |    65   |
 *  ----------------------------------------------------------------------------------
 *  |   0xe8  |   0xec  |   0xf0  |   0xf4   |   0xf8  |   0xfc  |  0x100  |  0x104  |
 *  ----------------------------------------------------------------------------------
 *  |        R14        |        R15         |       RDI         |       RSI         |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    66   |   67    |    68    |   69    |    70   |  71     |    72   |    73   |
 *  ----------------------------------------------------------------------------------
 *  |  0x108  |  0x10c  |  0x110   |  0x114  |  0x118  |  0x11c  |  0x120  |  0x124  |
 *  ----------------------------------------------------------------------------------
 *  |        RBX        |         RBP        |        RIP        |       EXIT        |
 *  ----------------------------------------------------------------------------------
 *                                                                                      *
 * *************************************************************************************/

.file	"make_x86_64_ms_pe_gas.asm"
.text
.p2align 4,,15
.globl	make_fcontext_v1
.def	make_fcontext_v1;	.scl	2;	.type	32;	.endef
.seh_proc	make_fcontext_v1
make_fcontext_v1:
.seh_endprologue

    /* first arg of make_fcontext_v1() == top of context-stack */
    movq  %rcx, %rax

    /* reserve 32byte shadow-space for context-function */
    leaq  -0x28(%rax), %rax

    /* shift address in RAX to lower 16 byte boundary */
    /* == pointer to fcontext_t and address of context stack */
    andq  $-16, %rax

    /* reserve space for context-data on context-stack */
    /* size for fc_mxcsr .. RIP + return-address for context-function */
    /* on context-function entry: (RSP -0x8) % 16 == 0 */
    leaq  -0x128(%rax), %rax

    /* third arg of make_fcontext_v1() == address of context-function */
    movq  %r8, 0x118(%rax)

    /* first arg of make_fcontext_v1() == top of context-stack */
    /* save top address of context stack as 'base' */
    movq  %rcx, 0xd0(%rax)
    /* second arg of make_fcontext_v1() == size of context-stack */
    /* negate stack size for LEA instruction (== substraction) */
    negq  %rdx
    /* compute bottom address of context stack (limit) */
    leaq  (%rcx,%rdx), %rcx
    /* save bottom address of context stack as 'limit' */
    movq  %rcx, 0xc8(%rax)
    /* save address of context stack limit as 'dealloction stack' */
    movq  %rcx, 0xc0(%rax)

    /* save MMX control- and status-word */
    stmxcsr  0xa8(%rax)
    /* save x87 control-word */
    fnstcw  0xac(%rax)

    /* compute abs address of label finish */
    leaq  finish(%rip), %rcx
    /* save address of finish as return-address for context-function */
    /* will be entered after context-function returns */
    movq  %rcx, 0x120(%rax)

    /* set indicator */
    movq  1, %rcx
    movq  %rcx, (%rax)

    ret /* return pointer to context-data */

finish:
    /* 32byte shadow-space for _exit() are */
    /* already reserved by make_fcontext_v1() */
    /* exit code is zero */
    xorq  %rcx, %rcx
    /* exit application */
    call  _exit
    hlt
.seh_endproc

.def	_exit;	.scl	2;	.type	32;	.endef  /* standard C library function */
